<?php
  BIndex::Add('SubscrThreads', 'file');
  BIndex::Add('Subscribers', 'file');

  BEvent::Hook('post moved', array('Subscriber', 'PostMoved'));
  BEvent::Hook('comment added', array('Subscriber', 'CommentAdded'));
  BEvent::Hook('on tpl vars: commenting', array('Subscriber', 'AddFieldsTo'));

  BConfig::$strings += array(
    'email - subscription link' => 'Your subscriptions - $siteName',

    'subscriber: form caption' => 'Subscribe by e-mail (%smanage%s):',
    'subscriber: form post' => 'To new comments for this post,',
    'subscriber: form thread' => 'for this thread only;',
    'subscriber: form no' => 'Do not subscribe'
  );

/* one-shot */
  $this->name = 'subscriber';
  $this->Caption('Подписки', 'ru');
  $this->info['user files'] = array('Subscriber', 'UserFiles');
/* install Subscriber */
class Subscriber {
  static $lastCheckboxIndex = 0;

  static function PostMoved($post, $newName, &$info) {
    $postLength = strlen($post);

    $threads = BIndex::SelectFrom('SubscrThreads');
    foreach ($threads as $thread => $emails) {
      if (strpos($thread, $post) === 0 and (strlen($thread) === $postLength or
                                            $thread[$postLength] === '/')) {
        if (isset($thread[$postLength])) {
          $new = BComments::ReferrerFor($newName, substr($thread, $postLength + 1));
        } else {
          $new = $newName;
        }

        BIndex::RenameIn('SubscrThreads', $thread, $new);
        foreach ($emails as $email) {
          BIndex::RenameIn('Subscribers', $email[0], $thread, $new);
        }
      }
    }
  }

  static function CommentAdded($parent, $comment, &$info) {
    self::NotifyOf($parent, $comment, $info);

    $email = $info['authorEMail'];
    if (($opt = &$info['subscribe']) and IsValidEMail($email)) {
      if ($opt === 'no') {
        self::Delete($email, BComments::PostOf($parent));
        self::Delete($email, $parent);
      } else {
        self::Add($email, $opt === 'post' ? BComments::PostOf($parent) : $parent, $info['author']);
      }
    }
  }

    static function Add($email, $post, $name) {
      BIndex::AddTo('SubscrThreads', $post, $email, $name);
      BIndex::AddTo('subscribers', $email, $post);
    }

    static function Delete($email, $post) {
      BIndex::RemoveFrom('SubscrThreads', $post, $email);
      BIndex::RemoveFrom('subscribers', $email, $post);
    }

  // null $parent will unsubscribe from all notifications.
  static function DeleteAllOf($email, $parent = null) {
    $list = BIndex::SelectFrom('subscribers', $email);
    foreach ($list as $thread) {
      if (!$parent or strpos($thread, $parent) === 0) {
        self::Delete($email, $thread);
      }
    }
  }

  static function NotifyOf($parent, $comment, $info) {
    $post = BComments::PostOf($parent);

    $list = array_merge(BIndex::SelectFrom('SubscrThreads', $post), self::EMailsOfThread($comment));

    $sent = array($info['authorEMail'] => true);

      foreach ($list as $item) {
        list($email, $name) = $item;

        if (empty($sent[$email])) {
          $sent[$email] = true;

          $vars = EMailVars::OnNewComment($parent, $comment, $info, $event);

          "$name" === '' or $vars['recepientName'] = $name;

          $vars['I!subscription'] =
            array('email - subscription links',
                  'manageLink' => self::ManageSubscrLinkFor($email),
                  'postUnsubscribeLink' => self::UnsubscriptionLinkFor($email, $post, '*'),
                  'allUnsubscribeLink' => self::UnsubscriptionLinkFor($email, '*'));

          EMail::SendFromTemplate($email, $event, $vars);
        }
      }
  }

    static function EMailsOfThread($comment) {
      $list = array();
      while ($comment = BComments::ParentCommentOf($comment)) {
        $list = array_merge($list, BIndex::SelectFrom('SubscrThreads', $comment));
      }
      return $list;
    }

  static function ManageSubscrLinkFor($email) {
    return BConfig::$engineURL.'subscriptions.php?email='.$email.'&key='.self::KeyOf($email);
  }

    static function UnsubscriptionLinkFor($email, $thread_1) {
      $args = func_get_args();
      array_unshift($args, self::KeyOf($email));
      return BConfig::$engineURL.'unsubscribe.php?'.base64_encode( join("\0", $args) );
    }

  static function KeyOf($email) { return MD5_24( BConfig::$secret."\11".strtolower($email) ); }

    static function CheckKeyOf($email, $compareToHash) {
      if (self::KeyOf($email) !== $compareToHash) {
        throw new BException("Subscription key is wrong for address $email.",
                             'valid key is '.self::KeyOf($email));
      }
    }

  static function AddFieldsTo(&$vars, $varPrefix) {
    $values = array();

    foreach (array('post', 'thread', 'no') as $opt) {
      $id = ++self::$lastCheckboxIndex;
      $values[] = '<input type="radio" name="subscribe" id="subscribe'.$id.'" value="'.$opt.'" /> '.
                  '<label for="subscribe'.$id.'">'.Translate('subscriber: form '.$opt).'</label> ';
    }

      if (!BComments::Exists( $vars[$varPrefix.'Query']['post'] )) {  // comment to post itself.
        unset($values[1]);
      }

    $caption = Translate('subscriber: form caption',
                         '<a href="'.BConfig::$engineURL.'subscriptions.php">', '</a>');

    $vars[$varPrefix.'Fields'][] = array('type' => 'other', 'value' => join($values),
                                         'caption' => $caption);

  }

  static function UserFiles() {
    $index1 = SingleInstanceOf('SubscrthreadsFileIndex');
    $index2 = SingleInstanceOf('SubscribersFileIndex');
    return array($index1->FileOf($index1->indexName), $index2->FileOf($index2->indexName));
  }
}

/* install SubscrthreadsFileIndex */
// hash of 'post or comment' => array( array('email', 'name'), ... )
class SubscrthreadsFileIndex extends BaseHashOfArraysFileIndex {
  public $indexName = 'subscr-threads';

  function Add($thread, $email, $name) { parent::Add($thread, array($email, $name)); }
}

/* install SubscribersFileIndex */
// hash of 'email' => array('post or comment', ...)
class SubscribersFileIndex extends BaseHashOfArraysFileIndex {
  public $indexName = 'subscribers';
}

/* one-shot */
return;
?>

/* install config/templates/email - subscription link.wiki */
Hello **$recepientName**,

You have requested a link to manage subscriptions at **$siteName** - (($link==here it is)).

You can use it to //subscribe to new threads// or //remove existing subscriptions//.

/* install config/templates/email - subscription links.wiki */
    **Subscription:**
      * (($manageLink==**Manage** your subscriptions))
      * (($postUnsubscribeLink==**Unsubscribe** from notifications)) for "(($postPermalink==$postTitle))"
      * (($allUnsubscribeLink==**Unsubscribe** from **all** notifications)) on **(($siteHome==$siteName))**

/* install subscriptions.php */
<?php
  require 'engine/page.php';

  echo '<h1>Managing subscription list &mdash; '.BConfig::$siteName.'</h1>';

  $email = &$_REQUEST['email'];
  $key = &$_REQUEST['key'];

  if (!empty($_REQUEST['request']) and IsValidEMail($email)) {
    $vars = array('link' => Subscriber::ManageSubscrLinkFor($email));
    EMail::SendFromTemplate($email, 'subscription link', $vars);
    echo "The link was sent to <strong>$email</strong>.";
    exit;
  }

  if (!$email or !$key) {
?>
  <p>
    Only owner of e-mail box can manage his subscriptions. For this reason to
    see the list you need to follow the link that you've received earlier.
  </p>

  <strong>If you haven't received any notifications so far you can request the link here:</strong>
  <form action="subscriptions.php" method="post">
    <input type="text" name="email" value="enter your e-mail" size="20" />
    <input type="submit" name="request" value="Request" />
  </form>
<?php
  exit;
  }

  Subscriber::CheckKeyOf($email, $key);

  echo "<h2>$email</h2>";
  if (!empty($_REQUEST['un'])) {
    echo '<p><strong>You were unsubscribed from selected threads.</strong></p>';
  }

  $addTo = &$_REQUEST['add'];
  if ($addTo and $post = BPosts::ByUrlTitle($addTo)) {
    Subscriber::Add($email, $post, '');
  }

  $threads = BIndex::SelectFrom('subscribers', $email);
  if (empty($threads)) {
    echo '<p><em>You are not subscribed to any posts on this blog.</em></p>';
  } else {?>
    <p>
      <a href="<?=Subscriber::UnsubscriptionLinkFor($email, '*')?>">
        <strong>Unsubscribe from all notifications</strong>
      </a>
    </p>
  <?php }?>

    Subscribe to new comments in this post (copy-paste its caption):
    <form action="subscriptions.php" method="post">
      <input type="hidden" name="email" value="<?=$email?>" />
      <input type="hidden" name="key" value="<?=$key?>" />

      <input type="text" name="add" />
      <input type="submit" value="Subscribe" />
    </form>

  <?php if ($threads) { ?>
    <h3>Notifications list (<?=count($threads)?>)</h3>
    <ol>
      <?php
        foreach ($threads as $thread) {
          $isThread = !BPosts::Exists($thread);
          $post = $isThread ? BComments::PostOf($thread) : $thread;
          $url = $isThread ? BComments::UrlOf($thread) : BPosts::UrlOf($post); ?>
        <li>
          <?=($isThread ? 'Thread in' : '<strong>Post</strong>')?>

          <a href="<?=$url?>"><?=BPosts::TitleOf($post, true)?></a>
          |
          <a href="<?=Subscriber::UnsubscriptionLinkFor($email, $thread)?>">Unsubscribe</a>
        </li>
        <?php }?>
    </ol>
  <?php }?>

/* install unsubscribe.php */
<?php
  require 'engine/page.php';

  $args = explode("\0", base64_decode( $_SERVER['QUERY_STRING'] ));
  if (!isset($args[2])) { throw new BException('Wrong parameters.'); }

    $key = array_shift($args);
    $email = array_shift($args);

  Subscriber::CheckKeyOf($email, $key);

  $prev = null;
  foreach ($args as $thread) {
    if ($thread === '*') {
      Subscriber::DeleteAllOf($email, $prev);
    } else {
      Subscriber::Delete($email, $thread);
      $prev = $thread;
    }
  }

  RedirectTo("subscriptions.php?key=$key&email=$email&un=1");
